/*
Copyright 2022 ojthetiny

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include QMK_KEYBOARD_H

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

	[0] = LAYOUT(
		KC_1,    KC_2, KC_5,
		KC_3,    KC_4
	)

};

oled_rotation_t oled_init_user(oled_rotation_t rotation) {
    return OLED_ROTATION_180;  // flips the display 180 degrees if offhand
  return rotation;
}

#if defined(ENCODER_MAP_ENABLE)
const uint16_t PROGMEM encoder_map[][NUM_ENCODERS][2] = {
    [0] =   { ENCODER_CCW_CW(KC_VOLD, KC_VOLU)},
    //                  Encoder 1                                   
};
#endif


static void render_logo(void) {
   static const char PROGMEM mkit_logo[] = {
// 'mkitoled', 128x32px
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 0x70, 0x00, 0x00, 0xe0, 0xf0, 0xe0, 0xf0, 0xe0, 0x00, 
0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 
0xf0, 0xf8, 0xf8, 0xf8, 0xb8, 0x00, 0x90, 0xbc, 0xbc, 0xbc, 0xbc, 0x18, 0x00, 0x00, 0x80, 0x80, 
0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xf8, 0x6c, 0xd6, 
0x24, 0xf4, 0x44, 0x6c, 0xc4, 0x6c, 0xc8, 0x98, 0xc8, 0x30, 0x90, 0x60, 0x20, 0xc0, 0x80, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xe0, 0xfe, 0xff, 0xff, 0xff, 0x2f, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xcf, 0x87, 0x07, 
0x21, 0xfc, 0xff, 0xff, 0xff, 0xcf, 0xc3, 0x87, 0xe7, 0xff, 0xff, 0xff, 0x7f, 0x03, 0xc0, 0xfe, 
0xff, 0xff, 0xff, 0x0f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x0f, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xe7, 
0x87, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0x7f, 0x07, 0xc0, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x07, 0x07, 
0xf7, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x80, 0xe0, 0x38, 0x9e, 0x43, 0xbc, 0x57, 0x28, 0x97, 
0x6d, 0x85, 0x1c, 0x82, 0x19, 0x00, 0xd0, 0x04, 0x51, 0xc3, 0x36, 0xce, 0xc9, 0x3c, 0xe0, 0xdd, 
0xb3, 0x06, 0xf8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x38, 0x73, 0x33, 0x3b, 0x43, 0x79, 0x70, 0x08, 0x30, 0x49, 0x5b, 0x23, 0x33, 0x33, 0x3b, 0x41, 
0x70, 0x38, 0x41, 0x3b, 0x33, 0x73, 0x13, 0x69, 0x33, 0x33, 0x4b, 0x53, 0x21, 0x70, 0x3b, 0x63, 
0x13, 0x73, 0x41, 0x00, 0x03, 0x73, 0x3b, 0x43, 0x39, 0x78, 0x50, 0x08, 0x31, 0x33, 0x0b, 0x73, 
0x7b, 0x31, 0x23, 0x5b, 0x33, 0x33, 0x60, 0x38, 0x63, 0x43, 0x3b, 0x73, 0x11, 0x78, 0x48, 0x31, 
0x13, 0x7b, 0x73, 0x03, 0x00, 0xc0, 0xfc, 0x3f, 0x6b, 0xbd, 0x77, 0xdd, 0xff, 0x36, 0x4c, 0x91, 
0xdd, 0x8a, 0xe6, 0x44, 0xb9, 0x3a, 0x64, 0x5e, 0xc5, 0xa6, 0x75, 0x18, 0x0e, 0x03, 0x01, 0x00, 
0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x3f, 0x0f, 
0x3e, 0x18, 0x2c, 0x3e, 0x1f, 0x20, 0x3f, 0x3f, 0x6b, 0x2d, 0x23, 0x38, 0x3f, 0x2f, 0x2b, 0x2f, 
0x01, 0x03, 0x3b, 0x3f, 0x07, 0x03, 0x09, 0x3e, 0x3f, 0x60, 0x38, 0x1f, 0x07, 0x38, 0x3f, 0x1b, 
0x1b, 0x0f, 0x0e, 0x00, 0x00, 0x3f, 0x2a, 0x39, 0x0d, 0x1a, 0x0c, 0x06, 0x02, 0x06, 0x07, 0x01, 
0x00, 0x00, 0x06, 0x0f, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };
/*static const char PROGMEM khor_logo[] = {
    // 'khoroled', 128x32px
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
0xc0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0xe0, 0xe0, 0xc0, 0x40, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf8, 0xf8, 0xfc, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xc0, 0xc0, 0xe0, 0xe0, 0xe0, 0xc0, 0xc0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40, 0x40, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 
0xc0, 0xc0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xf0, 0xff, 0xff, 
0xff, 0xff, 0xf3, 0xf8, 0x7c, 0x3e, 0x1f, 0x0f, 0x0f, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00, 0xc0, 
0xc0, 0xc0, 0xf8, 0xfe, 0xff, 0xbf, 0x8f, 0x80, 0x80, 0xc0, 0xff, 0xff, 0xff, 0x1f, 0x07, 0x00, 
0x00, 0x00, 0x00, 0xf0, 0xfc, 0xfe, 0xff, 0xff, 0x1f, 0x0f, 0x07, 0x03, 0x03, 0x03, 0x83, 0xfe, 
0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xf8, 0xfe, 0xff, 0x3f, 0x07, 0x00, 0x80, 0xc0, 
0xc0, 0xe3, 0xff, 0x7f, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x0f, 0xff, 0xff, 0xff, 0x1f, 
0x1f, 0x1f, 0x1c, 0x3c, 0x3c, 0x3c, 0x38, 0x78, 0x70, 0x70, 0x70, 0xe0, 0xc0, 0x80, 0x01, 0xc3, 
0xff, 0xff, 0x3f, 0x0f, 0x07, 0x07, 0x07, 0xc7, 0xff, 0xff, 0x3f, 0x0f, 0x07, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0x7f, 0xff, 0xff, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0x7e, 0x3f, 0x1f, 
0x07, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf3, 0xff, 0xff, 0x0f, 0x0f, 0x1f, 0x3f, 0x7f, 0x7f, 0x73, 
0xe3, 0xc1, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0f, 0x03, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x3f, 
0x0f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x20, 0x1f, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0x01, 0x03, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};*/
    oled_write_raw_P(mkit_logo, sizeof(mkit_logo));
}




bool oled_task_user(void) {
    render_logo();
    return false;
}

